/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.IpAddressListPanel;
import DE.siemens.ad.logo.dialog.comp.IPAddressJTextField;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.EthernetConnection;
import DE.siemens.ad.logo.model.NetworkNodeParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NetworkNodePanel
extends BlockParameterPanel {
    protected CardLayout fParameterPanelLayout;
    protected JPanel fParameterPanel;
    private JPanel fBlockPanel;
    protected JPanel fVMPanel;
    private JPanel fDiagnosticPanel;
    protected BorderJPanel fParameterTypePanel;
    protected JRadioButton fSlaveButton;
    protected JRadioButton fVMButton;
    protected JRadioButton fDiagnosticButton;
    protected EditableNumericSpinner fBitSpinner;
    protected EditableNumericSpinner fVBSpinner;
    protected JComboBox fBlockList;
    protected JComboBox fContantsList;
    protected JComboBox fDiagnosticList;
    protected IPAddressJTextField fTargetIP;
    private NetworkNodeParameter fParameter;
    private static final String INPUT = Language.getString("block.Input");
    private static final String OUTPUT = Language.getString("block.Output");
    private static final String MARKER = Language.getString("block.Marker");
    private static final String NETWORK_ERROR = Language.getString("panel.diagnostic.networkAccessErr");
    private static final String EM_BUS_ERROR = Language.getString("panel.diagnostic.emBusErr");
    private static final String SD_WR_ERROR = Language.getString("panel.diagnostic.sdCardRWErr");
    private static final String SD_WP_ERROR = Language.getString("panel.diagnostic.sdCardWriteProtectionErr");

    public NetworkNodePanel() {
        this.fParameter = (NetworkNodeParameter)this.fParameterReference;
    }

    public NetworkNodePanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.fParameter = (NetworkNodeParameter)this.fParameterReference;
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.fParameterPanelLayout = new CardLayout();
        this.fParameterPanel = new JPanel(this.fParameterPanelLayout);
        this.fParameterPanel.add((Component)this.getBlockPanel(), "Block");
        this.fParameterPanel.add((Component)this.getVMPanel(), "VM");
        this.fParameterPanel.add((Component)this.getDiagnosticPanel(), "Diagnostic");
        this.add((Component)this.getParameterTypePanel(), "North");
        this.add((Component)this.fParameterPanel, "Center");
    }

    protected JPanel getBlockPanel() {
        if (this.fBlockPanel == null) {
            this.fBlockPanel = new JPanel(new GridBagLayout());
            JLabel stationLabel = new JLabel(Language.getString("block.NetworkNode.slaveIP", "Slave IP:"));
            this.fTargetIP = new IPAddressJTextField();
            String lastIP = this.fParameter.getBlock().getWiringDiagram().getLastEditableIPAddress();
            if (!"".equals(lastIP)) {
                this.fTargetIP.setIP(lastIP);
            }
            JLabel blockType = new JLabel(Language.getString("compare.differentBlockType", "Block type") + ":");
            JLabel blockNumber = new JLabel(Language.getString("compare.differentBlockNumber", "Block number") + ":");
            this.fBlockList = new JComboBox();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fBlockPanel.add((Component)stationLabel, constraints);
            constraints.insets = new Insets(0, 5, 5, 0);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.fBlockPanel.add((Component)this.fTargetIP, constraints);
            constraints.insets = new Insets(0, 4, 5, 4);
            constraints.gridx = 2;
            constraints.gridy = 0;
            JButton button1 = new JButton("...");
            button1.setToolTipText(Language.getString("panel.networkNodePanel.selectSlave", "Click to select the configured slave IP"));
            button1.setPreferredSize(new Dimension(20, 18));
            button1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IpAddressListPanel addressListsPanel = new IpAddressListPanel();
                    addressListsPanel.setPreferredSize(new Dimension(230, 165));
                    SplittedDlg dialog = SplittedDlg.create(null, addressListsPanel, 3);
                    dialog.setTitle(Language.getString("panel.networkNodePanel.ipAddressList.title", "Configured Slave IP List"));
                    dialog.show();
                    if (dialog.getControlPanel().getResult() != 1) {
                        return;
                    }
                    NetworkNodePanel.this.fTargetIP.setIP(addressListsPanel.getSelectedIPAddress());
                }
            });
            this.fBlockPanel.add((Component)button1, constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            this.fBlockPanel.add((Component)new JPanel(), constraints);
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.fBlockPanel.add((Component)blockType, constraints);
            constraints.insets = new Insets(0, 5, 5, 0);
            constraints.gridx = 1;
            constraints.gridy = 1;
            this.fBlockPanel.add((Component)this.getContantsCombobox(), constraints);
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.fBlockPanel.add((Component)blockNumber, constraints);
            constraints.insets = new Insets(0, 5, 5, 0);
            constraints.gridx = 1;
            constraints.gridy = 2;
            this.fBlockPanel.add((Component)this.fBlockList, constraints);
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.weightx = 1.0;
            this.fBlockPanel.add((Component)new JPanel(), constraints);
        }
        return this.fBlockPanel;
    }

    protected JPanel getVMPanel() {
        if (this.fVMPanel == null) {
            this.fVMPanel = new JPanel(new GridBagLayout());
            JLabel vbAddress = new JLabel(Language.getString("block.NetworkNode.vb", "VB:"));
            this.fVBSpinner = new EditableNumericSpinner();
            this.fVBSpinner.setMinMax(0, this.getVMSize() - 1);
            JLabel bitAddress = new JLabel(Language.getString("block.NetworkNode.bit", "Bit:"));
            this.fBitSpinner = new EditableNumericSpinner();
            this.fBitSpinner.setMinMax(0, 7);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(10, 10, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fVMPanel.add((Component)vbAddress, constraints);
            constraints.insets = new Insets(5, 0, 5, 10);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.fVMPanel.add((Component)this.fVBSpinner, constraints);
            constraints.insets = new Insets(10, 10, 5, 5);
            constraints.gridx = 2;
            constraints.gridy = 0;
            this.fVMPanel.add((Component)bitAddress, constraints);
            constraints.insets = new Insets(5, 0, 5, 5);
            constraints.gridx = 3;
            constraints.gridy = 0;
            this.fVMPanel.add((Component)this.fBitSpinner, constraints);
            constraints.gridx = 4;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            this.fVMPanel.add((Component)new JPanel(), constraints);
            constraints.gridx = 4;
            constraints.gridy = 1;
            constraints.weighty = 1.0;
            this.fVMPanel.add((Component)new JPanel(), constraints);
        }
        return this.fVMPanel;
    }

    protected JPanel getDiagnosticPanel() {
        if (this.fDiagnosticPanel == null) {
            this.fDiagnosticPanel = new JPanel(new GridBagLayout());
            JLabel diagnosticLabel = new JLabel(Language.getString("panel.networkNodePanel.diagnosticType", "Diagnostic type:"));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.fDiagnosticPanel.add((Component)diagnosticLabel, constraints);
            constraints.insets = new Insets(0, 5, 5, 0);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.fDiagnosticPanel.add((Component)this.getDiagnosticCombobox(), constraints);
        }
        return this.fDiagnosticPanel;
    }

    protected BorderJPanel getParameterTypePanel() {
        if (this.fParameterTypePanel == null) {
            this.fParameterTypePanel = new BorderJPanel(new GridLayout(3, 1));
            this.fParameterTypePanel.setTitle(Language.getString("panel.networkNodePanel.readValueForm", "Read value from"));
            ButtonGroup connectionGroup = new ButtonGroup();
            this.fVMButton = new JRadioButton(Language.getString("block.NetworkNode.vm", "VM"));
            this.fSlaveButton = new JRadioButton(Language.getString("panel.networkNodePanel.slaveSelection", "Slave"));
            this.fDiagnosticButton = new JRadioButton(Language.getString("panel.networkNodePanel.diagnosticSelection", "Diagnostic"));
            this.fVMButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        NetworkNodePanel.this.fParameterPanelLayout.show(NetworkNodePanel.this.fParameterPanel, "VM");
                    }
                }
            });
            this.fSlaveButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        NetworkNodePanel.this.fParameterPanelLayout.show(NetworkNodePanel.this.fParameterPanel, "Block");
                    }
                }
            });
            this.fDiagnosticButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        NetworkNodePanel.this.fParameterPanelLayout.show(NetworkNodePanel.this.fParameterPanel, "Diagnostic");
                    }
                }
            });
            connectionGroup.add(this.fVMButton);
            connectionGroup.add(this.fSlaveButton);
            connectionGroup.add(this.fDiagnosticButton);
            this.fParameterTypePanel.add(this.fVMButton);
            this.fParameterTypePanel.add(this.fSlaveButton);
            this.fParameterTypePanel.add(this.fDiagnosticButton);
        }
        return this.fParameterTypePanel;
    }

    protected JComboBox getContantsCombobox() {
        if (this.fContantsList == null) {
            String[] blockType = new String[]{INPUT, OUTPUT};
            this.fContantsList = new JComboBox<String>(blockType);
            this.fContantsList.setSelectedItem(null);
            this.fContantsList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        int blockNumber = -1;
                        String blockName = "";
                        String selectedItem = e.getItem().toString();
                        if (selectedItem.equalsIgnoreCase(INPUT)) {
                            blockName = "I";
                            blockNumber = 6;
                        } else if (selectedItem.equalsIgnoreCase(OUTPUT)) {
                            blockName = "Q";
                            blockNumber = 7;
                        } else {
                            NetworkNodePanel.this.fBlockList.setModel(new DefaultComboBoxModel());
                        }
                        if (blockNumber != -1) {
                            Block block = ((NetworkNodeParameter)NetworkNodePanel.this.fParameterReference).getBlock();
                            int maxResource = block.getHardware().getMaxResource(blockNumber);
                            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                            for (int i = 1; i <= maxResource; ++i) {
                                model.addElement(blockName + i);
                            }
                            NetworkNodePanel.this.fBlockList.setModel(model);
                        }
                    }
                }
            });
        }
        return this.fContantsList;
    }

    protected JComboBox getDiagnosticCombobox() {
        if (this.fDiagnosticList == null) {
            String[] diagnosticType = new String[]{NETWORK_ERROR, EM_BUS_ERROR, SD_WR_ERROR, SD_WP_ERROR};
            this.fDiagnosticList = new JComboBox<String>(diagnosticType);
            this.fDiagnosticList.setSelectedItem(null);
        }
        return this.fDiagnosticList;
    }

    public void loadFieldContents() {
        if (this.fParameter.isForSlave()) {
            this.fSlaveButton.setSelected(true);
            this.fTargetIP.setIP(this.fParameter.getAddress());
            this.fContantsList.setSelectedItem(this.getConfiguredBlockName(this.fParameter.getConfiguredBlockType()));
            this.fBlockList.setSelectedIndex(this.fParameter.getConfiguredBlockNumber() - 1);
        } else if (this.fParameter.isForDiagnostic()) {
            this.fDiagnosticButton.setSelected(true);
            this.fDiagnosticList.setSelectedIndex(this.fParameter.getBitNumber());
        } else {
            this.fVMButton.setSelected(true);
            this.fVBSpinner.setValue(this.fParameter.getVMAddress());
            this.fBitSpinner.setValue(this.fParameter.getBitNumber());
        }
    }

    public boolean checkChanged() {
        if (this.fVMButton.isSelected()) {
            if (this.fParameter.isForSlave() || this.fParameter.getVMAddress() != this.fVBSpinner.getValue() || this.fParameter.getBitNumber() != this.fBitSpinner.getValue()) {
                return true;
            }
        } else if (this.fSlaveButton.isSelected()) {
            String remoteIP = this.fParameter.getAddress();
            int blockType = this.fParameter.getConfiguredBlockType();
            int blockNumber = this.fParameter.getConfiguredBlockNumber();
            if (!this.fParameter.isForSlave() || !this.fTargetIP.getIP().equals(remoteIP) || this.fContantsList.getSelectedItem() != null && blockType != this.getBlockTypeNumber(this.fContantsList.getSelectedItem().toString()) || blockNumber != this.fBlockList.getSelectedIndex() + 1) {
                return true;
            }
        } else if (this.fParameter.getConfiguredDiagnosticType() != this.fDiagnosticList.getSelectedIndex()) {
            return true;
        }
        return false;
    }

    public boolean checkFieldContents() {
        if (this.fSlaveButton.isSelected()) {
            if (this.fTargetIP.getIP().equals("")) {
                new LogoError(Language.getString("msg.file.IPIncorrect", "Please input a valid IP address.")).display();
                return false;
            }
            if (this.isClientServerConflict(this.fTargetIP.getIP())) {
                new LogoError(null, "ethernet.ethernetConfigurePanel.clientServerConflict", "You can not specify an IP address as both client and server, \nPlease choose another IP address.", 2, 0).display();
                return false;
            }
            if (this.fContantsList.getSelectedItem() == null) {
                new LogoError(Language.getString("block.NetworkNode.selectBlockType", "Please choose a block type")).display();
                return false;
            }
            if (this.fBlockList.getSelectedItem() == null) {
                new LogoError(Language.getString("block.NetworkNode.selectBlockNumber", "Please choose a block number")).display();
                return false;
            }
        } else if (this.fVMButton.isSelected()) {
            if (this.fBitSpinner.getValue() > this.fBitSpinner.getMax() || this.fBitSpinner.getValue() < this.fBitSpinner.getMin()) {
                Object[] info = new Object[]{this.fBitSpinner.getMin(), this.fBitSpinner.getMax()};
                new LogoError(null, "tool.vmConfigure.wrongBit", "The \"Bit\" number must be between % and %", info, 0, 0).display();
                return false;
            }
            if (this.fVBSpinner.getValue() > this.fVBSpinner.getMax() || this.fVBSpinner.getValue() < this.fVBSpinner.getMin()) {
                Object[] info = new Object[]{this.fVBSpinner.getMin(), this.fVBSpinner.getMax()};
                new LogoError(null, "tool.vmConfigure.wrongAddress", "The \"VB\" number must be between % and %", info, 0, 0).display();
                return false;
            }
        } else if (this.fDiagnosticList.getSelectedItem() == null) {
            new LogoError(Language.getString("block.NetworkNode.selectDiagnosticType", "Please choose a diagnostic type")).display();
            return false;
        }
        if (this.fParameter.isForSlave() != this.fSlaveButton.isSelected() || this.fSlaveButton.isSelected() && (!this.fParameter.getAddress().equals(this.fTargetIP.getIP()) || this.fParameter.getConfiguredBlockType() != this.getBlockTypeNumber(this.fContantsList.getSelectedItem().toString()) || this.fParameter.getConfiguredBlockNumber() != this.fBlockList.getSelectedIndex() + 1)) {
            String ip = "";
            int blockType = -1;
            int blockNumber = -1;
            if (this.fSlaveButton.isSelected()) {
                ip = this.fTargetIP.getIP();
                blockType = this.getBlockTypeNumber(this.fContantsList.getSelectedItem().toString());
                blockNumber = this.fBlockList.getSelectedIndex() + 1;
            }
            return this.fParameter.getBlock().getWiringDiagram().verifyConnResource(this.fParameter, ip, blockType, blockNumber, this.fSlaveButton.isSelected());
        }
        return true;
    }

    private boolean isClientServerConflict(String ip) {
        for (EthernetConnection conn : this.fParameter.getBlock().getWiringDiagram().getNetworkInfo().getEthernetConnections()) {
            if (conn.isForSlave() || !ip.equals(conn.getRemoteIP())) continue;
            return true;
        }
        return false;
    }

    public void storeFieldContents() {
        if (this.fVMButton.isSelected()) {
            this.fParameter.setForSlave(false);
            this.fParameter.setForDiagnostic(false);
            this.fParameter.setVMAddress(this.fVBSpinner.getValue());
            this.fParameter.setBitNumber(this.fBitSpinner.getValue());
            this.fParameter.setAddress("");
            this.fParameter.setConfiguredBlockType(-1);
            this.fParameter.setConfiguredBlockNumber(-1);
        } else if (this.fSlaveButton.isSelected()) {
            this.fParameter.setForSlave(true);
            this.fParameter.setForDiagnostic(false);
            this.fParameter.setAddress(this.fTargetIP.getIP());
            this.fParameter.setConfiguredBlockType(this.getBlockTypeNumber(this.fContantsList.getSelectedItem().toString()));
            this.fParameter.setConfiguredBlockNumber(this.fBlockList.getSelectedIndex() + 1);
            this.fParameter.setVMAddress(0);
            this.fParameter.setBitNumber(0);
            this.fParameter.getBlock().getWiringDiagram().setLastEditableIPAddress(this.fTargetIP.getIP());
        } else {
            this.fParameter.setForSlave(false);
            this.fParameter.setForDiagnostic(true);
            this.fParameter.setVMAddress(984);
            this.fParameter.setBitNumber(this.fDiagnosticList.getSelectedIndex());
            this.fParameter.setConfiguredDiagnosticType(this.fDiagnosticList.getSelectedIndex());
            this.fParameter.setAddress("");
            this.fParameter.setConfiguredBlockType(-1);
            this.fParameter.setConfiguredBlockNumber(-1);
        }
    }

    public String getHelpIdString() {
        return "block.NetworkNode";
    }

    protected String getConfiguredBlockName(int numberType) {
        if (6 == numberType) {
            return INPUT;
        }
        if (7 == numberType) {
            return OUTPUT;
        }
        if (10 == numberType) {
            return MARKER;
        }
        return "";
    }

    protected int getBlockTypeNumber(String typeName) {
        if (INPUT == typeName) {
            return 6;
        }
        if (OUTPUT == typeName) {
            return 7;
        }
        if (MARKER == typeName) {
            return 10;
        }
        return 0;
    }

    protected int getVMSize() {
        return this.fParameter.getBlock().getHardware().getIntProperty("nStartAddress");
    }
}

